/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.AbstractAggregateFunction;
import com.mckoi.database.AbstractFunction;
import com.mckoi.database.Caster;
import com.mckoi.database.Expression;
import com.mckoi.database.FunctionFactory;
import com.mckoi.database.GroupResolver;
import com.mckoi.database.Privileges;
import com.mckoi.database.QueryContext;
import com.mckoi.database.QueryPlanNode;
import com.mckoi.database.TBinaryType;
import com.mckoi.database.TBooleanType;
import com.mckoi.database.TDateType;
import com.mckoi.database.TJavaObjectType;
import com.mckoi.database.TNullType;
import com.mckoi.database.TNumericType;
import com.mckoi.database.TObject;
import com.mckoi.database.TStringType;
import com.mckoi.database.TType;
import com.mckoi.database.VariableResolver;
import com.mckoi.database.ViewDef;
import com.mckoi.database.global.BlobAccessor;
import com.mckoi.database.global.ByteLongObject;
import com.mckoi.database.global.CastHelper;
import com.mckoi.database.global.ObjectTranslator;
import com.mckoi.database.global.StringAccessor;
import com.mckoi.database.global.StringObject;
import com.mckoi.database.jdbc.SQLQuery;
import com.mckoi.util.BigNumber;
import com.mckoi.util.Cache;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;

final class InternalFunctionFactory
extends FunctionFactory {
    static /* synthetic */ Class class$com$mckoi$database$InternalFunctionFactory$DateObFunction;
    static /* synthetic */ Class class$com$mckoi$database$InternalFunctionFactory$TimeObFunction;
    static /* synthetic */ Class class$com$mckoi$database$InternalFunctionFactory$TimeStampObFunction;
    static /* synthetic */ Class class$com$mckoi$database$InternalFunctionFactory$DateFormatFunction;
    static /* synthetic */ Class class$com$mckoi$database$InternalFunctionFactory$ToNumberFunction;
    static /* synthetic */ Class class$com$mckoi$database$InternalFunctionFactory$SQLCastFunction;
    static /* synthetic */ Class class$com$mckoi$database$InternalFunctionFactory$LowerFunction;
    static /* synthetic */ Class class$com$mckoi$database$InternalFunctionFactory$UpperFunction;
    static /* synthetic */ Class class$com$mckoi$database$InternalFunctionFactory$ConcatFunction;
    static /* synthetic */ Class class$com$mckoi$database$InternalFunctionFactory$LengthFunction;
    static /* synthetic */ Class class$com$mckoi$database$InternalFunctionFactory$SubstringFunction;
    static /* synthetic */ Class class$com$mckoi$database$InternalFunctionFactory$SQLTrimFunction;
    static /* synthetic */ Class class$com$mckoi$database$InternalFunctionFactory$LTrimFunction;
    static /* synthetic */ Class class$com$mckoi$database$InternalFunctionFactory$RTrimFunction;
    static /* synthetic */ Class class$com$mckoi$database$InternalFunctionFactory$UserFunction;
    static /* synthetic */ Class class$com$mckoi$database$InternalFunctionFactory$PrivGroupsFunction;
    static /* synthetic */ Class class$com$mckoi$database$InternalFunctionFactory$CountFunction;
    static /* synthetic */ Class class$com$mckoi$database$InternalFunctionFactory$DistinctCountFunction;
    static /* synthetic */ Class class$com$mckoi$database$InternalFunctionFactory$AvgFunction;
    static /* synthetic */ Class class$com$mckoi$database$InternalFunctionFactory$SumFunction;
    static /* synthetic */ Class class$com$mckoi$database$InternalFunctionFactory$MinFunction;
    static /* synthetic */ Class class$com$mckoi$database$InternalFunctionFactory$MaxFunction;
    static /* synthetic */ Class class$com$mckoi$database$InternalFunctionFactory$AggOrFunction;
    static /* synthetic */ Class class$com$mckoi$database$InternalFunctionFactory$AbsFunction;
    static /* synthetic */ Class class$com$mckoi$database$InternalFunctionFactory$SignFunction;
    static /* synthetic */ Class class$com$mckoi$database$InternalFunctionFactory$ModFunction;
    static /* synthetic */ Class class$com$mckoi$database$InternalFunctionFactory$RoundFunction;
    static /* synthetic */ Class class$com$mckoi$database$InternalFunctionFactory$PowFunction;
    static /* synthetic */ Class class$com$mckoi$database$InternalFunctionFactory$SqrtFunction;
    static /* synthetic */ Class class$com$mckoi$database$InternalFunctionFactory$UniqueKeyFunction;
    static /* synthetic */ Class class$com$mckoi$database$InternalFunctionFactory$NextValFunction;
    static /* synthetic */ Class class$com$mckoi$database$InternalFunctionFactory$CurrValFunction;
    static /* synthetic */ Class class$com$mckoi$database$InternalFunctionFactory$SetValFunction;
    static /* synthetic */ Class class$com$mckoi$database$InternalFunctionFactory$HexToBinaryFunction;
    static /* synthetic */ Class class$com$mckoi$database$InternalFunctionFactory$BinaryToHexFunction;
    static /* synthetic */ Class class$com$mckoi$database$InternalFunctionFactory$LeastFunction;
    static /* synthetic */ Class class$com$mckoi$database$InternalFunctionFactory$GreatestFunction;
    static /* synthetic */ Class class$com$mckoi$database$InternalFunctionFactory$IfFunction;
    static /* synthetic */ Class class$com$mckoi$database$InternalFunctionFactory$CoalesceFunction;
    static /* synthetic */ Class class$com$mckoi$database$InternalFunctionFactory$JavaObjectInstantiation2;
    static /* synthetic */ Class class$com$mckoi$database$InternalFunctionFactory$ForeignRuleConvert;
    static /* synthetic */ Class class$com$mckoi$database$InternalFunctionFactory$SQLTypeString;
    static /* synthetic */ Class class$com$mckoi$database$InternalFunctionFactory$ViewDataConvert;
    static /* synthetic */ Class class$com$mckoi$database$InternalFunctionFactory$PrivilegeString;

    InternalFunctionFactory() {
    }

    public void init() {
        this.addFunction("dateob", class$com$mckoi$database$InternalFunctionFactory$DateObFunction == null ? (class$com$mckoi$database$InternalFunctionFactory$DateObFunction = InternalFunctionFactory.class$("com.mckoi.database.InternalFunctionFactory$DateObFunction")) : class$com$mckoi$database$InternalFunctionFactory$DateObFunction);
        this.addFunction("timeob", class$com$mckoi$database$InternalFunctionFactory$TimeObFunction == null ? (class$com$mckoi$database$InternalFunctionFactory$TimeObFunction = InternalFunctionFactory.class$("com.mckoi.database.InternalFunctionFactory$TimeObFunction")) : class$com$mckoi$database$InternalFunctionFactory$TimeObFunction);
        this.addFunction("timestampob", class$com$mckoi$database$InternalFunctionFactory$TimeStampObFunction == null ? (class$com$mckoi$database$InternalFunctionFactory$TimeStampObFunction = InternalFunctionFactory.class$("com.mckoi.database.InternalFunctionFactory$TimeStampObFunction")) : class$com$mckoi$database$InternalFunctionFactory$TimeStampObFunction);
        this.addFunction("dateformat", class$com$mckoi$database$InternalFunctionFactory$DateFormatFunction == null ? (class$com$mckoi$database$InternalFunctionFactory$DateFormatFunction = InternalFunctionFactory.class$("com.mckoi.database.InternalFunctionFactory$DateFormatFunction")) : class$com$mckoi$database$InternalFunctionFactory$DateFormatFunction);
        this.addFunction("tonumber", class$com$mckoi$database$InternalFunctionFactory$ToNumberFunction == null ? (class$com$mckoi$database$InternalFunctionFactory$ToNumberFunction = InternalFunctionFactory.class$("com.mckoi.database.InternalFunctionFactory$ToNumberFunction")) : class$com$mckoi$database$InternalFunctionFactory$ToNumberFunction);
        this.addFunction("sql_cast", class$com$mckoi$database$InternalFunctionFactory$SQLCastFunction == null ? (class$com$mckoi$database$InternalFunctionFactory$SQLCastFunction = InternalFunctionFactory.class$("com.mckoi.database.InternalFunctionFactory$SQLCastFunction")) : class$com$mckoi$database$InternalFunctionFactory$SQLCastFunction);
        this.addFunction("lower", class$com$mckoi$database$InternalFunctionFactory$LowerFunction == null ? (class$com$mckoi$database$InternalFunctionFactory$LowerFunction = InternalFunctionFactory.class$("com.mckoi.database.InternalFunctionFactory$LowerFunction")) : class$com$mckoi$database$InternalFunctionFactory$LowerFunction);
        this.addFunction("upper", class$com$mckoi$database$InternalFunctionFactory$UpperFunction == null ? (class$com$mckoi$database$InternalFunctionFactory$UpperFunction = InternalFunctionFactory.class$("com.mckoi.database.InternalFunctionFactory$UpperFunction")) : class$com$mckoi$database$InternalFunctionFactory$UpperFunction);
        this.addFunction("concat", class$com$mckoi$database$InternalFunctionFactory$ConcatFunction == null ? (class$com$mckoi$database$InternalFunctionFactory$ConcatFunction = InternalFunctionFactory.class$("com.mckoi.database.InternalFunctionFactory$ConcatFunction")) : class$com$mckoi$database$InternalFunctionFactory$ConcatFunction);
        this.addFunction("length", class$com$mckoi$database$InternalFunctionFactory$LengthFunction == null ? (class$com$mckoi$database$InternalFunctionFactory$LengthFunction = InternalFunctionFactory.class$("com.mckoi.database.InternalFunctionFactory$LengthFunction")) : class$com$mckoi$database$InternalFunctionFactory$LengthFunction);
        this.addFunction("substring", class$com$mckoi$database$InternalFunctionFactory$SubstringFunction == null ? (class$com$mckoi$database$InternalFunctionFactory$SubstringFunction = InternalFunctionFactory.class$("com.mckoi.database.InternalFunctionFactory$SubstringFunction")) : class$com$mckoi$database$InternalFunctionFactory$SubstringFunction);
        this.addFunction("sql_trim", class$com$mckoi$database$InternalFunctionFactory$SQLTrimFunction == null ? (class$com$mckoi$database$InternalFunctionFactory$SQLTrimFunction = InternalFunctionFactory.class$("com.mckoi.database.InternalFunctionFactory$SQLTrimFunction")) : class$com$mckoi$database$InternalFunctionFactory$SQLTrimFunction);
        this.addFunction("ltrim", class$com$mckoi$database$InternalFunctionFactory$LTrimFunction == null ? (class$com$mckoi$database$InternalFunctionFactory$LTrimFunction = InternalFunctionFactory.class$("com.mckoi.database.InternalFunctionFactory$LTrimFunction")) : class$com$mckoi$database$InternalFunctionFactory$LTrimFunction);
        this.addFunction("rtrim", class$com$mckoi$database$InternalFunctionFactory$RTrimFunction == null ? (class$com$mckoi$database$InternalFunctionFactory$RTrimFunction = InternalFunctionFactory.class$("com.mckoi.database.InternalFunctionFactory$RTrimFunction")) : class$com$mckoi$database$InternalFunctionFactory$RTrimFunction);
        this.addFunction("user", class$com$mckoi$database$InternalFunctionFactory$UserFunction == null ? (class$com$mckoi$database$InternalFunctionFactory$UserFunction = InternalFunctionFactory.class$("com.mckoi.database.InternalFunctionFactory$UserFunction")) : class$com$mckoi$database$InternalFunctionFactory$UserFunction);
        this.addFunction("privgroups", class$com$mckoi$database$InternalFunctionFactory$PrivGroupsFunction == null ? (class$com$mckoi$database$InternalFunctionFactory$PrivGroupsFunction = InternalFunctionFactory.class$("com.mckoi.database.InternalFunctionFactory$PrivGroupsFunction")) : class$com$mckoi$database$InternalFunctionFactory$PrivGroupsFunction);
        this.addFunction("count", class$com$mckoi$database$InternalFunctionFactory$CountFunction == null ? (class$com$mckoi$database$InternalFunctionFactory$CountFunction = InternalFunctionFactory.class$("com.mckoi.database.InternalFunctionFactory$CountFunction")) : class$com$mckoi$database$InternalFunctionFactory$CountFunction, 2);
        this.addFunction("distinct_count", class$com$mckoi$database$InternalFunctionFactory$DistinctCountFunction == null ? (class$com$mckoi$database$InternalFunctionFactory$DistinctCountFunction = InternalFunctionFactory.class$("com.mckoi.database.InternalFunctionFactory$DistinctCountFunction")) : class$com$mckoi$database$InternalFunctionFactory$DistinctCountFunction, 2);
        this.addFunction("avg", class$com$mckoi$database$InternalFunctionFactory$AvgFunction == null ? (class$com$mckoi$database$InternalFunctionFactory$AvgFunction = InternalFunctionFactory.class$("com.mckoi.database.InternalFunctionFactory$AvgFunction")) : class$com$mckoi$database$InternalFunctionFactory$AvgFunction, 2);
        this.addFunction("sum", class$com$mckoi$database$InternalFunctionFactory$SumFunction == null ? (class$com$mckoi$database$InternalFunctionFactory$SumFunction = InternalFunctionFactory.class$("com.mckoi.database.InternalFunctionFactory$SumFunction")) : class$com$mckoi$database$InternalFunctionFactory$SumFunction, 2);
        this.addFunction("min", class$com$mckoi$database$InternalFunctionFactory$MinFunction == null ? (class$com$mckoi$database$InternalFunctionFactory$MinFunction = InternalFunctionFactory.class$("com.mckoi.database.InternalFunctionFactory$MinFunction")) : class$com$mckoi$database$InternalFunctionFactory$MinFunction, 2);
        this.addFunction("max", class$com$mckoi$database$InternalFunctionFactory$MaxFunction == null ? (class$com$mckoi$database$InternalFunctionFactory$MaxFunction = InternalFunctionFactory.class$("com.mckoi.database.InternalFunctionFactory$MaxFunction")) : class$com$mckoi$database$InternalFunctionFactory$MaxFunction, 2);
        this.addFunction("aggor", class$com$mckoi$database$InternalFunctionFactory$AggOrFunction == null ? (class$com$mckoi$database$InternalFunctionFactory$AggOrFunction = InternalFunctionFactory.class$("com.mckoi.database.InternalFunctionFactory$AggOrFunction")) : class$com$mckoi$database$InternalFunctionFactory$AggOrFunction, 2);
        this.addFunction("abs", class$com$mckoi$database$InternalFunctionFactory$AbsFunction == null ? (class$com$mckoi$database$InternalFunctionFactory$AbsFunction = InternalFunctionFactory.class$("com.mckoi.database.InternalFunctionFactory$AbsFunction")) : class$com$mckoi$database$InternalFunctionFactory$AbsFunction);
        this.addFunction("sign", class$com$mckoi$database$InternalFunctionFactory$SignFunction == null ? (class$com$mckoi$database$InternalFunctionFactory$SignFunction = InternalFunctionFactory.class$("com.mckoi.database.InternalFunctionFactory$SignFunction")) : class$com$mckoi$database$InternalFunctionFactory$SignFunction);
        this.addFunction("mod", class$com$mckoi$database$InternalFunctionFactory$ModFunction == null ? (class$com$mckoi$database$InternalFunctionFactory$ModFunction = InternalFunctionFactory.class$("com.mckoi.database.InternalFunctionFactory$ModFunction")) : class$com$mckoi$database$InternalFunctionFactory$ModFunction);
        this.addFunction("round", class$com$mckoi$database$InternalFunctionFactory$RoundFunction == null ? (class$com$mckoi$database$InternalFunctionFactory$RoundFunction = InternalFunctionFactory.class$("com.mckoi.database.InternalFunctionFactory$RoundFunction")) : class$com$mckoi$database$InternalFunctionFactory$RoundFunction);
        this.addFunction("pow", class$com$mckoi$database$InternalFunctionFactory$PowFunction == null ? (class$com$mckoi$database$InternalFunctionFactory$PowFunction = InternalFunctionFactory.class$("com.mckoi.database.InternalFunctionFactory$PowFunction")) : class$com$mckoi$database$InternalFunctionFactory$PowFunction);
        this.addFunction("sqrt", class$com$mckoi$database$InternalFunctionFactory$SqrtFunction == null ? (class$com$mckoi$database$InternalFunctionFactory$SqrtFunction = InternalFunctionFactory.class$("com.mckoi.database.InternalFunctionFactory$SqrtFunction")) : class$com$mckoi$database$InternalFunctionFactory$SqrtFunction);
        this.addFunction("uniquekey", class$com$mckoi$database$InternalFunctionFactory$UniqueKeyFunction == null ? (class$com$mckoi$database$InternalFunctionFactory$UniqueKeyFunction = InternalFunctionFactory.class$("com.mckoi.database.InternalFunctionFactory$UniqueKeyFunction")) : class$com$mckoi$database$InternalFunctionFactory$UniqueKeyFunction, 3);
        this.addFunction("nextval", class$com$mckoi$database$InternalFunctionFactory$NextValFunction == null ? (class$com$mckoi$database$InternalFunctionFactory$NextValFunction = InternalFunctionFactory.class$("com.mckoi.database.InternalFunctionFactory$NextValFunction")) : class$com$mckoi$database$InternalFunctionFactory$NextValFunction, 3);
        this.addFunction("currval", class$com$mckoi$database$InternalFunctionFactory$CurrValFunction == null ? (class$com$mckoi$database$InternalFunctionFactory$CurrValFunction = InternalFunctionFactory.class$("com.mckoi.database.InternalFunctionFactory$CurrValFunction")) : class$com$mckoi$database$InternalFunctionFactory$CurrValFunction, 3);
        this.addFunction("setval", class$com$mckoi$database$InternalFunctionFactory$SetValFunction == null ? (class$com$mckoi$database$InternalFunctionFactory$SetValFunction = InternalFunctionFactory.class$("com.mckoi.database.InternalFunctionFactory$SetValFunction")) : class$com$mckoi$database$InternalFunctionFactory$SetValFunction, 3);
        this.addFunction("hextobinary", class$com$mckoi$database$InternalFunctionFactory$HexToBinaryFunction == null ? (class$com$mckoi$database$InternalFunctionFactory$HexToBinaryFunction = InternalFunctionFactory.class$("com.mckoi.database.InternalFunctionFactory$HexToBinaryFunction")) : class$com$mckoi$database$InternalFunctionFactory$HexToBinaryFunction);
        this.addFunction("binarytohex", class$com$mckoi$database$InternalFunctionFactory$BinaryToHexFunction == null ? (class$com$mckoi$database$InternalFunctionFactory$BinaryToHexFunction = InternalFunctionFactory.class$("com.mckoi.database.InternalFunctionFactory$BinaryToHexFunction")) : class$com$mckoi$database$InternalFunctionFactory$BinaryToHexFunction);
        this.addFunction("least", class$com$mckoi$database$InternalFunctionFactory$LeastFunction == null ? (class$com$mckoi$database$InternalFunctionFactory$LeastFunction = InternalFunctionFactory.class$("com.mckoi.database.InternalFunctionFactory$LeastFunction")) : class$com$mckoi$database$InternalFunctionFactory$LeastFunction);
        this.addFunction("greatest", class$com$mckoi$database$InternalFunctionFactory$GreatestFunction == null ? (class$com$mckoi$database$InternalFunctionFactory$GreatestFunction = InternalFunctionFactory.class$("com.mckoi.database.InternalFunctionFactory$GreatestFunction")) : class$com$mckoi$database$InternalFunctionFactory$GreatestFunction);
        this.addFunction("if", class$com$mckoi$database$InternalFunctionFactory$IfFunction == null ? (class$com$mckoi$database$InternalFunctionFactory$IfFunction = InternalFunctionFactory.class$("com.mckoi.database.InternalFunctionFactory$IfFunction")) : class$com$mckoi$database$InternalFunctionFactory$IfFunction);
        this.addFunction("coalesce", class$com$mckoi$database$InternalFunctionFactory$CoalesceFunction == null ? (class$com$mckoi$database$InternalFunctionFactory$CoalesceFunction = InternalFunctionFactory.class$("com.mckoi.database.InternalFunctionFactory$CoalesceFunction")) : class$com$mckoi$database$InternalFunctionFactory$CoalesceFunction);
        this.addFunction("_new_JavaObject", class$com$mckoi$database$InternalFunctionFactory$JavaObjectInstantiation2 == null ? (class$com$mckoi$database$InternalFunctionFactory$JavaObjectInstantiation2 = InternalFunctionFactory.class$("com.mckoi.database.InternalFunctionFactory$JavaObjectInstantiation2")) : class$com$mckoi$database$InternalFunctionFactory$JavaObjectInstantiation2);
        this.addFunction("i_frule_convert", class$com$mckoi$database$InternalFunctionFactory$ForeignRuleConvert == null ? (class$com$mckoi$database$InternalFunctionFactory$ForeignRuleConvert = InternalFunctionFactory.class$("com.mckoi.database.InternalFunctionFactory$ForeignRuleConvert")) : class$com$mckoi$database$InternalFunctionFactory$ForeignRuleConvert);
        this.addFunction("i_sql_type", class$com$mckoi$database$InternalFunctionFactory$SQLTypeString == null ? (class$com$mckoi$database$InternalFunctionFactory$SQLTypeString = InternalFunctionFactory.class$("com.mckoi.database.InternalFunctionFactory$SQLTypeString")) : class$com$mckoi$database$InternalFunctionFactory$SQLTypeString);
        this.addFunction("i_view_data", class$com$mckoi$database$InternalFunctionFactory$ViewDataConvert == null ? (class$com$mckoi$database$InternalFunctionFactory$ViewDataConvert = InternalFunctionFactory.class$("com.mckoi.database.InternalFunctionFactory$ViewDataConvert")) : class$com$mckoi$database$InternalFunctionFactory$ViewDataConvert);
        this.addFunction("i_privilege_string", class$com$mckoi$database$InternalFunctionFactory$PrivilegeString == null ? (class$com$mckoi$database$InternalFunctionFactory$PrivilegeString = InternalFunctionFactory.class$("com.mckoi.database.InternalFunctionFactory$PrivilegeString")) : class$com$mckoi$database$InternalFunctionFactory$PrivilegeString);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class PrivilegeString
    extends AbstractFunction {
        public PrivilegeString(Expression[] params) {
            super("i_privilege_string", params);
            if (this.parameterCount() != 1) {
                throw new RuntimeException("i_privilege_string function must have one argument.");
            }
        }

        public TObject evaluate(GroupResolver group, VariableResolver resolver, QueryContext context) {
            TObject priv_bit_ob = this.getParameter(0).evaluate(group, resolver, context);
            int priv_bit = ((BigNumber)priv_bit_ob.getObject()).intValue();
            Privileges privs = new Privileges();
            privs = privs.add(priv_bit);
            return TObject.stringVal(privs.toString());
        }

        public TType returnTType(VariableResolver resolver, QueryContext context) {
            return TType.STRING_TYPE;
        }
    }

    private static class ViewDataConvert
    extends AbstractFunction {
        public ViewDataConvert(Expression[] params) {
            super("i_view_data", params);
            if (this.parameterCount() != 2) {
                throw new RuntimeException("i_sql_type function must have two arguments.");
            }
        }

        public TObject evaluate(GroupResolver group, VariableResolver resolver, QueryContext context) {
            TObject command = this.getParameter(0).evaluate(group, resolver, context);
            TObject data = this.getParameter(1).evaluate(group, resolver, context);
            String command_str = command.getObject().toString();
            ByteLongObject blob = (ByteLongObject)data.getObject();
            if (command_str.equalsIgnoreCase("referenced tables")) {
                ViewDef view_def = ViewDef.deserializeFromBlob(blob);
                QueryPlanNode node = view_def.getQueryPlanNode();
                ArrayList touched_tables = node.discoverTableNames(new ArrayList());
                StringBuffer buf = new StringBuffer();
                int sz = touched_tables.size();
                for (int i = 0; i < sz; ++i) {
                    buf.append(touched_tables.get(i));
                    if (i >= sz - 1) continue;
                    buf.append(", ");
                }
                return TObject.stringVal(new String(buf));
            }
            if (command_str.equalsIgnoreCase("plan dump")) {
                ViewDef view_def = ViewDef.deserializeFromBlob(blob);
                QueryPlanNode node = view_def.getQueryPlanNode();
                StringBuffer buf = new StringBuffer();
                node.debugString(0, buf);
                return TObject.stringVal(new String(buf));
            }
            if (command_str.equalsIgnoreCase("query string")) {
                SQLQuery query = SQLQuery.deserializeFromBlob(blob);
                return TObject.stringVal(query.toString());
            }
            return TObject.nullVal();
        }

        public TType returnTType(VariableResolver resolver, QueryContext context) {
            return TType.STRING_TYPE;
        }
    }

    private static class SQLTypeString
    extends AbstractFunction {
        public SQLTypeString(Expression[] params) {
            super("i_sql_type", params);
            if (this.parameterCount() != 3) {
                throw new RuntimeException("i_sql_type function must have three arguments.");
            }
        }

        public TObject evaluate(GroupResolver group, VariableResolver resolver, QueryContext context) {
            TObject type_string = this.getParameter(0).evaluate(group, resolver, context);
            TObject type_size = this.getParameter(1).evaluate(group, resolver, context);
            TObject type_scale = this.getParameter(2).evaluate(group, resolver, context);
            StringBuffer result_str = new StringBuffer();
            result_str.append(type_string.toString());
            long size = -1L;
            long scale = -1L;
            if (!type_size.isNull()) {
                size = type_size.toBigNumber().longValue();
            }
            if (!type_scale.isNull()) {
                scale = type_scale.toBigNumber().longValue();
            }
            if (size != -1L) {
                result_str.append('(');
                result_str.append(size);
                if (scale != -1L) {
                    result_str.append(',');
                    result_str.append(scale);
                }
                result_str.append(')');
            }
            return TObject.stringVal(new String(result_str));
        }

        public TType returnTType(VariableResolver resolver, QueryContext context) {
            return TType.STRING_TYPE;
        }
    }

    private static class ForeignRuleConvert
    extends AbstractFunction {
        public ForeignRuleConvert(Expression[] params) {
            super("i_frule_convert", params);
            if (this.parameterCount() != 1) {
                throw new RuntimeException("i_frule_convert function must have one argument.");
            }
        }

        public TObject evaluate(GroupResolver group, VariableResolver resolver, QueryContext context) {
            int v;
            TObject ob = this.getParameter(0).evaluate(group, resolver, context);
            String str = null;
            if (!ob.isNull()) {
                str = ob.getObject().toString();
            }
            if (str == null || str.equals("") || str.equals("NO ACTION")) {
                v = 3;
            } else if (str.equals("CASCADE")) {
                v = 0;
            } else if (str.equals("SET NULL")) {
                v = 2;
            } else if (str.equals("SET DEFAULT")) {
                v = 4;
            } else if (str.equals("RESTRICT")) {
                v = 1;
            } else {
                throw new Error("Unrecognised foreign key rule: " + str);
            }
            return TObject.intVal(v);
        }
    }

    private static class JavaObjectInstantiation2
    extends AbstractFunction {
        public JavaObjectInstantiation2(Expression[] params) {
            super("_new_JavaObject", params);
            if (this.parameterCount() < 1) {
                throw new RuntimeException("_new_JavaObject function must have one argument.");
            }
        }

        public TObject evaluate(GroupResolver group, VariableResolver resolver, QueryContext context) {
            int arg_len = this.parameterCount() - 1;
            TObject[] args = new TObject[arg_len];
            for (int i = 0; i < args.length; ++i) {
                args[i] = this.getParameter(i + 1).evaluate(group, resolver, context);
            }
            Caster.deserializeJavaObjects(args);
            try {
                String clazz = this.getParameter(0).evaluate(null, resolver, context).getObject().toString();
                Class<?> c = Class.forName(clazz);
                Constructor[] constructs = c.getConstructors();
                Constructor bestConstructor = Caster.findBestConstructor(constructs, args);
                if (bestConstructor == null) {
                    String argTypes = Caster.getArgTypesString(args);
                    throw new RuntimeException("Unable to find a constructor for '" + clazz + "' that matches given arguments: " + argTypes);
                }
                Object[] casted_args = Caster.castArgsToConstructor(args, bestConstructor);
                Object ob = bestConstructor.newInstance(casted_args);
                ByteLongObject serialized_ob = ObjectTranslator.serialize(ob);
                return new TObject(new TJavaObjectType(clazz), serialized_ob);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Class not found: " + e.getMessage());
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Instantiation Error: " + e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Illegal Access Error: " + e.getMessage());
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("Illegal Argument Error: " + e.getMessage());
            }
            catch (InvocationTargetException e) {
                Throwable th;
                String msg = e.getMessage();
                if (msg == null && (th = e.getTargetException()) != null) {
                    msg = th.getClass().getName() + ": " + th.getMessage();
                }
                throw new RuntimeException("Invocation Target Error: " + msg);
            }
        }

        public TType returnTType(VariableResolver resolver, QueryContext context) {
            String clazz = this.getParameter(0).evaluate(null, resolver, context).getObject().toString();
            return new TJavaObjectType(clazz);
        }
    }

    private static class JavaObjectInstantiation
    extends AbstractFunction {
        public JavaObjectInstantiation(Expression[] params) {
            super("_new_JavaObject", params);
            if (this.parameterCount() < 1) {
                throw new RuntimeException("_new_JavaObject function must have one argument.");
            }
        }

        public TObject evaluate(GroupResolver group, VariableResolver resolver, QueryContext context) {
            int arg_len = this.parameterCount() - 1;
            Object[] args = new Object[arg_len];
            for (int i = 0; i < args.length; ++i) {
                args[i] = this.getParameter(i + 1).evaluate(group, resolver, context).getObject();
            }
            Object[] casted_args = new Object[arg_len];
            try {
                String clazz = this.getParameter(0).evaluate(null, resolver, context).getObject().toString();
                Class<?> c = Class.forName(clazz);
                Constructor<?>[] constructs = c.getConstructors();
                block7: for (int i = 0; i < constructs.length; ++i) {
                    Class<?>[] construct_args = constructs[i].getParameterTypes();
                    if (construct_args.length != arg_len) continue;
                    for (int n = 0; n < arg_len; ++n) {
                        if (construct_args[n].isPrimitive()) {
                            String class_name = construct_args[n].getName();
                            if (args[n] instanceof Number) {
                                Number num = (Number)args[n];
                                if (class_name.equals("byte")) {
                                    casted_args[n] = new Byte(num.byteValue());
                                    continue;
                                }
                                if (class_name.equals("char")) {
                                    casted_args[n] = new Character((char)num.intValue());
                                    continue;
                                }
                                if (class_name.equals("double")) {
                                    casted_args[n] = new Double(num.doubleValue());
                                    continue;
                                }
                                if (class_name.equals("float")) {
                                    casted_args[n] = new Float(num.floatValue());
                                    continue;
                                }
                                if (class_name.equals("int")) {
                                    casted_args[n] = new Integer(num.intValue());
                                    continue;
                                }
                                if (class_name.equals("long")) {
                                    casted_args[n] = new Long(num.longValue());
                                    continue;
                                }
                                if (!class_name.equals("short")) break block7;
                                casted_args[n] = new Short(num.shortValue());
                                continue;
                            }
                            if (!(args[n] instanceof Boolean) || !class_name.equals("boolean")) break block7;
                            casted_args[n] = args[n];
                            continue;
                        }
                        if (!construct_args[n].isInstance(args[n])) break block7;
                        casted_args[n] = args[n];
                    }
                    Object ob = constructs[i].newInstance(casted_args);
                    ByteLongObject serialized_ob = ObjectTranslator.serialize(ob);
                    return new TObject(new TJavaObjectType(clazz), serialized_ob);
                }
                throw new RuntimeException("Unable to find a constructor for '" + clazz + "' that matches given arguments.");
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Class not found: " + e.getMessage());
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Instantiation Error: " + e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Illegal Access Error: " + e.getMessage());
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("Illegal Argument Error: " + e.getMessage());
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Invocation Target Error: " + e.getMessage());
            }
        }

        public TType returnTType(VariableResolver resolver, QueryContext context) {
            String clazz = this.getParameter(0).evaluate(null, resolver, context).getObject().toString();
            return new TJavaObjectType(clazz);
        }
    }

    private static class CoalesceFunction
    extends AbstractFunction {
        public CoalesceFunction(Expression[] params) {
            super("coalesce", params);
            if (this.parameterCount() < 1) {
                throw new RuntimeException("COALESCE function must have at least 1 parameter.");
            }
        }

        public TObject evaluate(GroupResolver group, VariableResolver resolver, QueryContext context) {
            int count = this.parameterCount();
            for (int i = 0; i < count - 1; ++i) {
                TObject res = this.getParameter(i).evaluate(group, resolver, context);
                if (res.isNull()) continue;
                return res;
            }
            return this.getParameter(count - 1).evaluate(group, resolver, context);
        }

        public TType returnTType(VariableResolver resolver, QueryContext context) {
            int count = this.parameterCount();
            for (int i = 0; i < count; ++i) {
                TType t = this.getParameter(i).returnTType(resolver, context);
                if (t instanceof TNullType) continue;
                return t;
            }
            return TType.NULL_TYPE;
        }
    }

    private static class IfFunction
    extends AbstractFunction {
        public IfFunction(Expression[] params) {
            super("if", params);
            if (this.parameterCount() != 3) {
                throw new RuntimeException("IF function must have exactly three arguments.");
            }
        }

        public TObject evaluate(GroupResolver group, VariableResolver resolver, QueryContext context) {
            TObject res = this.getParameter(0).evaluate(group, resolver, context);
            if (res.getTType() instanceof TBooleanType) {
                if (res.compareTo(TObject.booleanVal(true)) == 0) {
                    return this.getParameter(1).evaluate(group, resolver, context);
                }
                return this.getParameter(2).evaluate(group, resolver, context);
            }
            return TObject.nullVal();
        }

        public TType returnTType(VariableResolver resolver, QueryContext context) {
            TType t1 = this.getParameter(1).returnTType(resolver, context);
            if (t1 instanceof TNullType) {
                return this.getParameter(2).returnTType(resolver, context);
            }
            return t1;
        }
    }

    private static class ToNumberFunction
    extends AbstractFunction {
        public ToNumberFunction(Expression[] params) {
            super("tonumber", params);
            if (this.parameterCount() != 1) {
                throw new RuntimeException("TONUMBER function must have one argument.");
            }
        }

        public TObject evaluate(GroupResolver group, VariableResolver resolver, QueryContext context) {
            return this.getParameter(0).evaluate(group, resolver, context).castTo(TType.NUMERIC_TYPE);
        }
    }

    static class DateFormatFunction
    extends AbstractFunction {
        static final Cache formatter_cache = new Cache(127, 90, 10);

        public DateFormatFunction(Expression[] params) {
            super("dateformat", params);
            if (this.parameterCount() != 2) {
                throw new RuntimeException("'dateformat' function must have exactly two parameters.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TObject evaluate(GroupResolver group, VariableResolver resolver, QueryContext context) {
            TObject datein = this.getParameter(0).evaluate(group, resolver, context);
            TObject format = this.getParameter(1).evaluate(group, resolver, context);
            if (datein.isNull()) {
                return datein;
            }
            if (!(datein.getTType() instanceof TDateType)) {
                throw new RuntimeException("Date to format must be DATE, TIME or TIMESTAMP");
            }
            Date d = (Date)datein.getObject();
            String format_string = format.toString();
            Cache cache = formatter_cache;
            synchronized (cache) {
                SimpleDateFormat formatter = (SimpleDateFormat)formatter_cache.get(format_string);
                if (formatter == null) {
                    formatter = new SimpleDateFormat(format_string);
                    formatter_cache.put(format_string, formatter);
                }
                return TObject.stringVal(formatter.format(d));
            }
        }

        public TType returnTType(VariableResolver resolver, QueryContext context) {
            return TType.STRING_TYPE;
        }
    }

    static class TimeStampObFunction
    extends AbstractFunction {
        private static final TType TIMESTAMP_TYPE = new TDateType(93);

        public TimeStampObFunction(Expression[] params) {
            super("timestampob", params);
            if (this.parameterCount() > 1) {
                throw new RuntimeException("'timestampob' function must have only one or zero parameters.");
            }
        }

        public TObject evaluate(GroupResolver group, VariableResolver resolver, QueryContext context) {
            if (this.parameterCount() == 0) {
                return new TObject(TIMESTAMP_TYPE, new Date());
            }
            TObject exp_res = this.getParameter(0).evaluate(group, resolver, context);
            if (exp_res.isNull()) {
                return new TObject(TIMESTAMP_TYPE, new Date());
            }
            String date_str = exp_res.getObject().toString();
            return new TObject(TIMESTAMP_TYPE, CastHelper.toTimeStamp(date_str));
        }

        public TType returnTType(VariableResolver resolver, QueryContext context) {
            return TIMESTAMP_TYPE;
        }
    }

    static class TimeObFunction
    extends AbstractFunction {
        private static final TType TIME_TYPE = new TDateType(92);

        public TimeObFunction(Expression[] params) {
            super("timeob", params);
            if (this.parameterCount() > 1) {
                throw new RuntimeException("'timeob' function must have only one or zero parameters.");
            }
        }

        private TObject timeNow() {
            Calendar c = Calendar.getInstance();
            c.setLenient(false);
            int hour = c.get(11);
            int minute = c.get(12);
            int second = c.get(13);
            int millisecond = c.get(14);
            c.set(1970, 0, 1);
            return new TObject(TIME_TYPE, c.getTime());
        }

        public TObject evaluate(GroupResolver group, VariableResolver resolver, QueryContext context) {
            if (this.parameterCount() == 0) {
                return this.timeNow();
            }
            TObject exp_res = this.getParameter(0).evaluate(group, resolver, context);
            if (exp_res.isNull()) {
                return this.timeNow();
            }
            String date_str = exp_res.getObject().toString();
            return new TObject(TIME_TYPE, CastHelper.toTime(date_str));
        }

        public TType returnTType(VariableResolver resolver, QueryContext context) {
            return TIME_TYPE;
        }
    }

    static class DateObFunction
    extends AbstractFunction {
        private static final TType DATE_TYPE = new TDateType(91);
        private static final DateFormat date_format_sho;
        private static final DateFormat date_format_sql;
        private static final DateFormat date_format_med;
        private static final DateFormat date_format_lon;
        private static final DateFormat date_format_ful;

        private static TObject dateVal(Date d) {
            return new TObject(DATE_TYPE, d);
        }

        public DateObFunction(Expression[] params) {
            super("dateob", params);
            if (this.parameterCount() > 1) {
                throw new RuntimeException("'dateob' function must have only one or zero parameters.");
            }
        }

        public TObject evaluate(GroupResolver group, VariableResolver resolver, QueryContext context) {
            if (this.parameterCount() == 0) {
                return DateObFunction.dateVal(new Date());
            }
            TObject exp_res = this.getParameter(0).evaluate(group, resolver, context);
            if (exp_res.isNull()) {
                return DateObFunction.dateVal(new Date());
            }
            if (exp_res.getTType() instanceof TNumericType) {
                BigNumber num = (BigNumber)exp_res.getObject();
                return DateObFunction.dateVal(new Date(num.longValue()));
            }
            String date_str = exp_res.getObject().toString();
            DateFormat dateFormat = date_format_sho;
            synchronized (dateFormat) {
                try {
                    return DateObFunction.dateVal(date_format_sql.parse(date_str));
                }
                catch (ParseException e) {
                    try {
                        return DateObFunction.dateVal(date_format_sho.parse(date_str));
                    }
                    catch (ParseException e2) {
                        try {
                            return DateObFunction.dateVal(date_format_med.parse(date_str));
                        }
                        catch (ParseException e3) {
                            try {
                                return DateObFunction.dateVal(date_format_lon.parse(date_str));
                            }
                            catch (ParseException e4) {
                                try {
                                    return DateObFunction.dateVal(date_format_ful.parse(date_str));
                                }
                                catch (ParseException e5) {
                                    throw new RuntimeException("Unable to parse date string '" + date_str + "'");
                                }
                            }
                        }
                    }
                }
            }
        }

        public TType returnTType(VariableResolver resolver, QueryContext context) {
            return DATE_TYPE;
        }

        static {
            date_format_med = DateFormat.getDateInstance(2);
            date_format_sho = DateFormat.getDateInstance(3);
            date_format_lon = DateFormat.getDateInstance(1);
            date_format_ful = DateFormat.getDateInstance(0);
            date_format_sql = new SimpleDateFormat("yyyy-MM-dd");
        }
    }

    static class SQLCastFunction
    extends AbstractFunction {
        private TType cast_to_type;

        public SQLCastFunction(Expression[] params) {
            super("sql_cast", params);
            if (this.parameterCount() != 2) {
                throw new RuntimeException("'sql_cast' function must have only 2 arguments.");
            }
            Expression exp = params[1];
            if (exp.size() != 1) {
                throw new RuntimeException("'sql_cast' function must have simple second parameter.");
            }
            Object vob = params[1].last();
            if (!(vob instanceof TObject)) {
                throw new RuntimeException("'sql_cast' function must have simple second parameter.");
            }
            TObject ob = (TObject)vob;
            String encoded_type = ob.getObject().toString();
            this.cast_to_type = TType.decodeString(encoded_type);
        }

        public TObject evaluate(GroupResolver group, VariableResolver resolver, QueryContext context) {
            TObject ob = this.getParameter(0).evaluate(group, resolver, context);
            if (ob.getTType().getSQLType() == this.cast_to_type.getSQLType()) {
                return ob;
            }
            Object casted_ob = TType.castObjectToTType(ob.getObject(), this.cast_to_type);
            return new TObject(this.cast_to_type, casted_ob);
        }

        public TType returnTType(VariableResolver resolver, QueryContext context) {
            return this.cast_to_type;
        }
    }

    private static class BinaryToHexFunction
    extends AbstractFunction {
        static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};

        public BinaryToHexFunction(Expression[] params) {
            super("binarytohex", params);
            if (this.parameterCount() != 1) {
                throw new RuntimeException("'binarytohex' function must have only 1 argument.");
            }
        }

        public TObject evaluate(GroupResolver group, VariableResolver resolver, QueryContext context) {
            TObject ob = this.getParameter(0).evaluate(group, resolver, context);
            if (ob.isNull()) {
                return ob;
            }
            if (ob.getTType() instanceof TBinaryType) {
                StringBuffer buf = new StringBuffer();
                BlobAccessor blob = (BlobAccessor)ob.getObject();
                InputStream bin = blob.getInputStream();
                try {
                    int bval = bin.read();
                    while (bval != -1) {
                        buf.append(digits[bval >> 4 & 0xF]);
                        buf.append(digits[bval & 0xF]);
                        bval = bin.read();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new RuntimeException("IO Error: " + e.getMessage());
                }
                return TObject.stringVal(buf.toString());
            }
            throw new RuntimeException("'binarytohex' parameter type is not a binary object.");
        }

        public TType returnTType(VariableResolver resolver, QueryContext context) {
            return TType.STRING_TYPE;
        }
    }

    private static class HexToBinaryFunction
    extends AbstractFunction {
        public HexToBinaryFunction(Expression[] params) {
            super("hextobinary", params);
            if (this.parameterCount() != 1) {
                throw new RuntimeException("'hextobinary' function must have only 1 argument.");
            }
        }

        public TObject evaluate(GroupResolver group, VariableResolver resolver, QueryContext context) {
            String str = this.getParameter(0).evaluate(group, resolver, context).getObject().toString();
            int str_len = str.length();
            if (str_len == 0) {
                return new TObject(TType.BINARY_TYPE, new ByteLongObject(new byte[0]));
            }
            byte[] buf = new byte[(str_len + 1) / 2];
            int index = 0;
            if (buf.length * 2 != str_len) {
                buf[0] = (byte)Character.digit(str.charAt(0), 16);
                ++index;
            }
            int v = 0;
            for (int i = index; i < str_len; i += 2) {
                v = Character.digit(str.charAt(i), 16) << 4 | Character.digit(str.charAt(i + 1), 16);
                buf[index] = (byte)(v & 0xFF);
                ++index;
            }
            return new TObject(TType.BINARY_TYPE, new ByteLongObject(buf));
        }

        public TType returnTType(VariableResolver resolver, QueryContext context) {
            return TType.BINARY_TYPE;
        }
    }

    private static class SetValFunction
    extends AbstractFunction {
        public SetValFunction(Expression[] params) {
            super("setval", params);
            if (this.parameterCount() != 2) {
                throw new RuntimeException("'setval' function must have 2 arguments.");
            }
        }

        public TObject evaluate(GroupResolver group, VariableResolver resolver, QueryContext context) {
            String str = this.getParameter(0).evaluate(group, resolver, context).getObject().toString();
            BigNumber num = this.getParameter(1).evaluate(group, resolver, context).toBigNumber();
            long v = num.longValue();
            context.setSequenceValue(str, v);
            return TObject.longVal(v);
        }

        public TType returnTType(VariableResolver resolver, QueryContext context) {
            return TType.NUMERIC_TYPE;
        }
    }

    private static class CurrValFunction
    extends AbstractFunction {
        public CurrValFunction(Expression[] params) {
            super("currval", params);
            if (this.parameterCount() != 1) {
                throw new RuntimeException("'currval' function must have only 1 argument.");
            }
        }

        public TObject evaluate(GroupResolver group, VariableResolver resolver, QueryContext context) {
            String str = this.getParameter(0).evaluate(group, resolver, context).getObject().toString();
            long v = context.currentSequenceValue(str);
            return TObject.longVal(v);
        }

        public TType returnTType(VariableResolver resolver, QueryContext context) {
            return TType.NUMERIC_TYPE;
        }
    }

    private static class NextValFunction
    extends AbstractFunction {
        public NextValFunction(Expression[] params) {
            super("nextval", params);
            if (this.parameterCount() != 1) {
                throw new RuntimeException("'nextval' function must have only 1 argument.");
            }
        }

        public TObject evaluate(GroupResolver group, VariableResolver resolver, QueryContext context) {
            String str = this.getParameter(0).evaluate(group, resolver, context).getObject().toString();
            long v = context.nextSequenceValue(str);
            return TObject.longVal(v);
        }

        public TType returnTType(VariableResolver resolver, QueryContext context) {
            return TType.NUMERIC_TYPE;
        }
    }

    private static class UniqueKeyFunction
    extends AbstractFunction {
        public UniqueKeyFunction(Expression[] params) {
            super("uniquekey", params);
            if (this.parameterCount() != 1) {
                throw new RuntimeException("'uniquekey' function must have only 1 argument.");
            }
        }

        public TObject evaluate(GroupResolver group, VariableResolver resolver, QueryContext context) {
            String str = this.getParameter(0).evaluate(group, resolver, context).getObject().toString();
            long v = context.nextSequenceValue(str);
            return TObject.longVal(v);
        }

        public TType returnTType(VariableResolver resolver, QueryContext context) {
            return TType.NUMERIC_TYPE;
        }
    }

    private static class GreatestFunction
    extends AbstractFunction {
        public GreatestFunction(Expression[] params) {
            super("greatest", params);
            if (this.parameterCount() < 1) {
                throw new RuntimeException("Greatest function must have at least 1 argument.");
            }
        }

        public TObject evaluate(GroupResolver group, VariableResolver resolver, QueryContext context) {
            TObject great = null;
            for (int i = 0; i < this.parameterCount(); ++i) {
                TObject ob = this.getParameter(i).evaluate(group, resolver, context);
                if (ob.isNull()) {
                    return ob;
                }
                if (great != null && ob.compareTo(great) <= 0) continue;
                great = ob;
            }
            return great;
        }

        public TType returnTType(VariableResolver resolver, QueryContext context) {
            return this.getParameter(0).returnTType(resolver, context);
        }
    }

    private static class LeastFunction
    extends AbstractFunction {
        public LeastFunction(Expression[] params) {
            super("least", params);
            if (this.parameterCount() < 1) {
                throw new RuntimeException("Least function must have at least 1 argument.");
            }
        }

        public TObject evaluate(GroupResolver group, VariableResolver resolver, QueryContext context) {
            TObject least = null;
            for (int i = 0; i < this.parameterCount(); ++i) {
                TObject ob = this.getParameter(i).evaluate(group, resolver, context);
                if (ob.isNull()) {
                    return ob;
                }
                if (least != null && ob.compareTo(least) >= 0) continue;
                least = ob;
            }
            return least;
        }

        public TType returnTType(VariableResolver resolver, QueryContext context) {
            return this.getParameter(0).returnTType(resolver, context);
        }
    }

    private static class SqrtFunction
    extends AbstractFunction {
        public SqrtFunction(Expression[] params) {
            super("sqrt", params);
            if (this.parameterCount() != 1) {
                throw new RuntimeException("Sqrt function must have one argument.");
            }
        }

        public TObject evaluate(GroupResolver group, VariableResolver resolver, QueryContext context) {
            TObject ob = this.getParameter(0).evaluate(group, resolver, context);
            if (ob.isNull()) {
                return ob;
            }
            return TObject.bigNumberVal(ob.toBigNumber().sqrt());
        }
    }

    private static class PowFunction
    extends AbstractFunction {
        public PowFunction(Expression[] params) {
            super("pow", params);
            if (this.parameterCount() != 2) {
                throw new RuntimeException("Pow function must have two arguments.");
            }
        }

        public TObject evaluate(GroupResolver group, VariableResolver resolver, QueryContext context) {
            TObject ob1 = this.getParameter(0).evaluate(group, resolver, context);
            TObject ob2 = this.getParameter(1).evaluate(group, resolver, context);
            if (ob1.isNull()) {
                return ob1;
            }
            if (ob2.isNull()) {
                return ob2;
            }
            double v = ob1.toBigNumber().doubleValue();
            double w = ob2.toBigNumber().doubleValue();
            return TObject.doubleVal(Math.pow(v, w));
        }
    }

    private static class RoundFunction
    extends AbstractFunction {
        public RoundFunction(Expression[] params) {
            super("round", params);
            if (this.parameterCount() < 1 || this.parameterCount() > 2) {
                throw new RuntimeException("Round function must have one or two arguments.");
            }
        }

        public TObject evaluate(GroupResolver group, VariableResolver resolver, QueryContext context) {
            TObject ob1 = this.getParameter(0).evaluate(group, resolver, context);
            if (ob1.isNull()) {
                return ob1;
            }
            BigNumber v = ob1.toBigNumber();
            int d = 0;
            if (this.parameterCount() == 2) {
                TObject ob2 = this.getParameter(1).evaluate(group, resolver, context);
                d = ob2.isNull() ? 0 : ob2.toBigNumber().intValue();
            }
            return TObject.bigNumberVal(v.setScale(d, 4));
        }
    }

    private static class ModFunction
    extends AbstractFunction {
        public ModFunction(Expression[] params) {
            super("mod", params);
            if (this.parameterCount() != 2) {
                throw new RuntimeException("Mod function must have two arguments.");
            }
        }

        public TObject evaluate(GroupResolver group, VariableResolver resolver, QueryContext context) {
            TObject ob1 = this.getParameter(0).evaluate(group, resolver, context);
            TObject ob2 = this.getParameter(1).evaluate(group, resolver, context);
            if (ob1.isNull()) {
                return ob1;
            }
            if (ob2.isNull()) {
                return ob2;
            }
            double v = ob1.toBigNumber().doubleValue();
            double m = ob2.toBigNumber().doubleValue();
            return TObject.doubleVal(v % m);
        }
    }

    private static class SignFunction
    extends AbstractFunction {
        public SignFunction(Expression[] params) {
            super("sign", params);
            if (this.parameterCount() != 1) {
                throw new RuntimeException("Sign function must have one argument.");
            }
        }

        public TObject evaluate(GroupResolver group, VariableResolver resolver, QueryContext context) {
            TObject ob = this.getParameter(0).evaluate(group, resolver, context);
            if (ob.isNull()) {
                return ob;
            }
            BigNumber num = ob.toBigNumber();
            return TObject.intVal(num.signum());
        }
    }

    private static class AbsFunction
    extends AbstractFunction {
        public AbsFunction(Expression[] params) {
            super("abs", params);
            if (this.parameterCount() != 1) {
                throw new RuntimeException("Abs function must have one argument.");
            }
        }

        public TObject evaluate(GroupResolver group, VariableResolver resolver, QueryContext context) {
            TObject ob = this.getParameter(0).evaluate(group, resolver, context);
            if (ob.isNull()) {
                return ob;
            }
            BigNumber num = ob.toBigNumber();
            return TObject.bigNumberVal(num.abs());
        }
    }

    private static class RTrimFunction
    extends AbstractFunction {
        public RTrimFunction(Expression[] params) {
            super("rtrim", params);
            if (this.parameterCount() != 1) {
                throw new RuntimeException("rtrim function may only have 1 parameter.");
            }
        }

        public TObject evaluate(GroupResolver group, VariableResolver resolver, QueryContext context) {
            TObject ob = this.getParameter(0).evaluate(group, resolver, context);
            if (ob.isNull()) {
                return ob;
            }
            String str = ob.getObject().toString();
            int scan = str.length() - 1;
            int i = str.lastIndexOf(" ", scan);
            while (scan >= 0 && i != -1 && i == scan - 2) {
                i = str.lastIndexOf(" ", --scan);
            }
            str = str.substring(0, Math.max(0, scan + 1));
            return TObject.stringVal(str);
        }

        public TType returnTType(VariableResolver resolver, QueryContext context) {
            return TType.STRING_TYPE;
        }
    }

    private static class LTrimFunction
    extends AbstractFunction {
        public LTrimFunction(Expression[] params) {
            super("ltrim", params);
            if (this.parameterCount() != 1) {
                throw new RuntimeException("ltrim function may only have 1 parameter.");
            }
        }

        public TObject evaluate(GroupResolver group, VariableResolver resolver, QueryContext context) {
            int scan;
            TObject ob = this.getParameter(0).evaluate(group, resolver, context);
            if (ob.isNull()) {
                return ob;
            }
            String str = ob.getObject().toString();
            for (scan = 0; scan < str.length() && str.indexOf(32, scan) == scan; ++scan) {
            }
            str = str.substring(Math.min(scan, str.length()));
            return TObject.stringVal(str);
        }

        public TType returnTType(VariableResolver resolver, QueryContext context) {
            return TType.STRING_TYPE;
        }
    }

    private static class SQLTrimFunction
    extends AbstractFunction {
        public SQLTrimFunction(Expression[] params) {
            super("sql_trim", params);
            if (this.parameterCount() != 3) {
                throw new RuntimeException("SQL Trim function must have three parameters.");
            }
        }

        public TObject evaluate(GroupResolver group, VariableResolver resolver, QueryContext context) {
            int scan;
            TObject ttype = this.getParameter(0).evaluate(group, resolver, context);
            TObject cob = this.getParameter(1).evaluate(group, resolver, context);
            if (cob.isNull()) {
                return cob;
            }
            if (ttype.isNull()) {
                return TObject.stringVal((StringObject)null);
            }
            String characters = cob.getObject().toString();
            String ttype_str = ttype.getObject().toString();
            TObject ob = this.getParameter(2).evaluate(group, resolver, context);
            if (ob.isNull()) {
                return ob;
            }
            String str = ob.getObject().toString();
            int skip = characters.length();
            if (ttype_str.equals("leading") || ttype_str.equals("both")) {
                for (scan = 0; scan < str.length() && str.indexOf(characters, scan) == scan; scan += skip) {
                }
                str = str.substring(Math.min(scan, str.length()));
            }
            if (ttype_str.equals("trailing") || ttype_str.equals("both")) {
                scan = str.length() - 1;
                int i = str.lastIndexOf(characters, scan);
                while (scan >= 0 && i != -1 && i == scan - skip + 1) {
                    i = str.lastIndexOf(characters, scan -= skip);
                }
                str = str.substring(0, Math.max(0, scan + 1));
            }
            return TObject.stringVal(str);
        }

        public TType returnTType(VariableResolver resolver, QueryContext context) {
            return TType.STRING_TYPE;
        }
    }

    private static class SubstringFunction
    extends AbstractFunction {
        public SubstringFunction(Expression[] params) {
            super("substring", params);
            if (this.parameterCount() < 1 || this.parameterCount() > 3) {
                throw new RuntimeException("Substring function needs one to three arguments.");
            }
        }

        public TObject evaluate(GroupResolver group, VariableResolver resolver, QueryContext context) {
            TObject ob = this.getParameter(0).evaluate(group, resolver, context);
            if (ob.isNull()) {
                return ob;
            }
            String str = ob.getObject().toString();
            int pcount = this.parameterCount();
            int str_length = str.length();
            int arg1 = 1;
            int arg2 = str_length;
            if (pcount >= 2) {
                arg1 = this.getParameter(1).evaluate(group, resolver, context).toBigNumber().intValue();
            }
            if (pcount >= 3) {
                arg2 = this.getParameter(2).evaluate(group, resolver, context).toBigNumber().intValue();
            }
            if (arg1 < 1) {
                arg1 = 1;
            }
            if (arg1 > str_length) {
                return TObject.stringVal("");
            }
            if (arg2 + arg1 > str_length) {
                arg2 = str_length - arg1 + 1;
            }
            if (arg2 < 1) {
                return TObject.stringVal("");
            }
            return TObject.stringVal(str.substring(arg1 - 1, arg1 + arg2 - 1));
        }

        public TType returnTType() {
            return TType.STRING_TYPE;
        }
    }

    private static class LengthFunction
    extends AbstractFunction {
        public LengthFunction(Expression[] params) {
            super("length", params);
            if (this.parameterCount() != 1) {
                throw new RuntimeException("Length function must have one argument.");
            }
        }

        public TObject evaluate(GroupResolver group, VariableResolver resolver, QueryContext context) {
            TObject ob = this.getParameter(0).evaluate(group, resolver, context);
            if (ob.isNull()) {
                return ob;
            }
            if (ob.getTType() instanceof TBinaryType) {
                BlobAccessor blob = (BlobAccessor)ob.getObject();
                return TObject.intVal(blob.length());
            }
            if (ob.getTType() instanceof TStringType) {
                StringAccessor str = (StringAccessor)ob.getObject();
                return TObject.intVal(str.length());
            }
            return TObject.intVal(ob.getObject().toString().length());
        }
    }

    private static class ConcatFunction
    extends AbstractFunction {
        public ConcatFunction(Expression[] params) {
            super("concat", params);
            if (this.parameterCount() < 1) {
                throw new RuntimeException("Concat function must have at least one argument.");
            }
        }

        public TObject evaluate(GroupResolver group, VariableResolver resolver, QueryContext context) {
            StringBuffer cc = new StringBuffer();
            Locale str_locale = null;
            int str_strength = 0;
            int str_decomposition = 0;
            for (int i = 0; i < this.parameterCount(); ++i) {
                Expression cur_parameter = this.getParameter(i);
                TObject ob = cur_parameter.evaluate(group, resolver, context);
                if (!ob.isNull()) {
                    cc.append(ob.getObject().toString());
                    TType type = ob.getTType();
                    if (str_locale != null || !(type instanceof TStringType)) continue;
                    TStringType str_type = (TStringType)type;
                    str_locale = str_type.getLocale();
                    str_strength = str_type.getStrength();
                    str_decomposition = str_type.getDecomposition();
                    continue;
                }
                return ob;
            }
            TStringType type = str_locale != null ? new TStringType(12, -1, str_locale, str_strength, str_decomposition) : TType.STRING_TYPE;
            return new TObject(type, new String(cc));
        }

        public TType returnTType(VariableResolver resolver, QueryContext context) {
            Locale str_locale = null;
            int str_strength = 0;
            int str_decomposition = 0;
            for (int i = 0; i < this.parameterCount() && str_locale == null; ++i) {
                TType type = this.getParameter(i).returnTType(resolver, context);
                if (!(type instanceof TStringType)) continue;
                TStringType str_type = (TStringType)type;
                str_locale = str_type.getLocale();
                str_strength = str_type.getStrength();
                str_decomposition = str_type.getDecomposition();
            }
            if (str_locale != null) {
                return new TStringType(12, -1, str_locale, str_strength, str_decomposition);
            }
            return TType.STRING_TYPE;
        }
    }

    private static class UpperFunction
    extends AbstractFunction {
        public UpperFunction(Expression[] params) {
            super("upper", params);
            if (this.parameterCount() != 1) {
                throw new RuntimeException("Upper function must have one argument.");
            }
        }

        public TObject evaluate(GroupResolver group, VariableResolver resolver, QueryContext context) {
            TObject ob = this.getParameter(0).evaluate(group, resolver, context);
            if (ob.isNull()) {
                return ob;
            }
            return new TObject(ob.getTType(), ob.getObject().toString().toUpperCase());
        }

        public TType returnTType() {
            return TType.STRING_TYPE;
        }
    }

    private static class LowerFunction
    extends AbstractFunction {
        public LowerFunction(Expression[] params) {
            super("lower", params);
            if (this.parameterCount() != 1) {
                throw new RuntimeException("Lower function must have one argument.");
            }
        }

        public TObject evaluate(GroupResolver group, VariableResolver resolver, QueryContext context) {
            TObject ob = this.getParameter(0).evaluate(group, resolver, context);
            if (ob.isNull()) {
                return ob;
            }
            return new TObject(ob.getTType(), ob.getObject().toString().toLowerCase());
        }

        public TType returnTType() {
            return TType.STRING_TYPE;
        }
    }

    private static class PrivGroupsFunction
    extends AbstractFunction {
        public PrivGroupsFunction(Expression[] params) {
            super("privgroups", params);
            if (this.parameterCount() > 0) {
                throw new RuntimeException("'privgroups' function must have no arguments.");
            }
        }

        public TObject evaluate(GroupResolver group, VariableResolver resolver, QueryContext context) {
            throw new RuntimeException("'PrivGroups' function currently not working.");
        }

        public TType returnTType() {
            return TType.STRING_TYPE;
        }
    }

    private static class UserFunction
    extends AbstractFunction {
        public UserFunction(Expression[] params) {
            super("user", params);
            if (this.parameterCount() > 0) {
                throw new RuntimeException("'user' function must have no arguments.");
            }
        }

        public TObject evaluate(GroupResolver group, VariableResolver resolver, QueryContext context) {
            return TObject.stringVal(context.getUserName());
        }

        public TType returnTType() {
            return TType.STRING_TYPE;
        }
    }

    private static class AggOrFunction
    extends AbstractAggregateFunction {
        public AggOrFunction(Expression[] params) {
            super("aggor", params);
        }

        public TObject evalAggregate(GroupResolver group, QueryContext context, TObject ob1, TObject ob2) {
            if (ob1 != null) {
                if (ob2.isNull()) {
                    return ob1;
                }
                if (!ob1.isNull()) {
                    return ob1.operatorOr(ob2);
                }
                return ob2;
            }
            return ob2;
        }
    }

    private static class MaxFunction
    extends AbstractAggregateFunction {
        public MaxFunction(Expression[] params) {
            super("max", params);
        }

        public TObject evalAggregate(GroupResolver group, QueryContext context, TObject ob1, TObject ob2) {
            if (ob1 != null) {
                if (ob2.isNull()) {
                    return ob1;
                }
                if (!ob1.isNull() && ob1.compareToNoNulls(ob2) > 0) {
                    return ob1;
                }
                return ob2;
            }
            return ob2;
        }

        public TType returnTType(VariableResolver resolver, QueryContext context) {
            return this.getParameter(0).returnTType(resolver, context);
        }
    }

    private static class MinFunction
    extends AbstractAggregateFunction {
        public MinFunction(Expression[] params) {
            super("min", params);
        }

        public TObject evalAggregate(GroupResolver group, QueryContext context, TObject ob1, TObject ob2) {
            if (ob1 != null) {
                if (ob2.isNull()) {
                    return ob1;
                }
                if (!ob1.isNull() && ob1.compareToNoNulls(ob2) < 0) {
                    return ob1;
                }
                return ob2;
            }
            return ob2;
        }

        public TType returnTType(VariableResolver resolver, QueryContext context) {
            return this.getParameter(0).returnTType(resolver, context);
        }
    }

    private static class SumFunction
    extends AbstractAggregateFunction {
        public SumFunction(Expression[] params) {
            super("sum", params);
        }

        public TObject evalAggregate(GroupResolver group, QueryContext context, TObject ob1, TObject ob2) {
            if (ob1 != null) {
                if (ob2.isNull()) {
                    return ob1;
                }
                if (!ob1.isNull()) {
                    return ob1.operatorAdd(ob2);
                }
                return ob2;
            }
            return ob2;
        }
    }

    private static class AvgFunction
    extends AbstractAggregateFunction {
        public AvgFunction(Expression[] params) {
            super("avg", params);
        }

        public TObject evalAggregate(GroupResolver group, QueryContext context, TObject ob1, TObject ob2) {
            if (ob1 != null) {
                if (ob2.isNull()) {
                    return ob1;
                }
                if (!ob1.isNull()) {
                    return ob1.operatorAdd(ob2);
                }
                return ob2;
            }
            return ob2;
        }

        public TObject postEvalAggregate(GroupResolver group, QueryContext context, TObject result) {
            if (result.isNull()) {
                return result;
            }
            return result.operatorDivide(TObject.intVal(group.size()));
        }
    }

    private static class DistinctCountFunction
    extends AbstractFunction {
        public DistinctCountFunction(Expression[] params) {
            super("distinct_count", params);
            this.setAggregate(true);
            if (this.parameterCount() <= 0) {
                throw new RuntimeException("'distinct_count' function must have at least one argument.");
            }
        }

        public TObject evaluate(GroupResolver group, VariableResolver resolver, QueryContext context) {
            if (group == null) {
                throw new RuntimeException("'count' can only be used as an aggregate function.");
            }
            int rows = group.size();
            if (rows <= 1) {
                return TObject.intVal(rows);
            }
            final int cols = this.parameterCount();
            final TObject[] group_r = new TObject[rows * cols];
            int n = 0;
            for (int i = 0; i < rows; ++i) {
                VariableResolver vr = group.getVariableResolver(i);
                for (int p = 0; p < cols; ++p) {
                    Expression exp = this.getParameter(p);
                    group_r[n + p] = exp.evaluate(null, vr, context);
                }
                n += cols;
            }
            Comparator c = new Comparator(){

                public int compare(Object ob1, Object ob2) {
                    int r1 = (Integer)ob1;
                    int r2 = (Integer)ob2;
                    int index1 = r1 * cols;
                    int index2 = r2 * cols;
                    for (int n = 0; n < cols; ++n) {
                        int v = group_r[index1 + n].compareTo(group_r[index2 + n]);
                        if (v == 0) continue;
                        return v;
                    }
                    return 0;
                }
            };
            Object[] list = new Object[rows];
            for (int i = 0; i < rows; ++i) {
                list[i] = new Integer(i);
            }
            Arrays.sort(list, c);
            int distinct_count = 1;
            for (int i = 1; i < rows; ++i) {
                int v = c.compare(list[i], list[i - 1]);
                if (v > 0) {
                    ++distinct_count;
                    continue;
                }
                if (v >= 0) continue;
                throw new Error("Assertion failed - the distinct list does not appear to be sorted.");
            }
            if (list.length > 0) {
                int first_entry = (Integer)list[0];
                boolean first_is_null = true;
                for (int m = 0; m < cols && first_is_null; ++m) {
                    TObject val = group_r[first_entry * cols + m];
                    if (val.isNull()) continue;
                    first_is_null = false;
                }
                if (first_is_null) {
                    --distinct_count;
                }
            }
            return TObject.intVal(distinct_count);
        }
    }

    private static class CountFunction
    extends AbstractFunction {
        public CountFunction(Expression[] params) {
            super("count", params);
            this.setAggregate(true);
            if (this.parameterCount() != 1) {
                throw new RuntimeException("'count' function must have one argument.");
            }
        }

        public TObject evaluate(GroupResolver group, VariableResolver resolver, QueryContext context) {
            TObject result;
            if (group == null) {
                throw new RuntimeException("'count' can only be used as an aggregate function.");
            }
            int size = group.size();
            if (size == 0 || this.isGlob()) {
                result = TObject.intVal(size);
            } else {
                int total_count = size;
                Expression exp = this.getParameter(0);
                for (int i = 0; i < size; ++i) {
                    TObject val = exp.evaluate(null, group.getVariableResolver(i), context);
                    if (!val.isNull()) continue;
                    --total_count;
                }
                result = TObject.intVal(total_count);
            }
            return result;
        }
    }
}

